-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- define the source file and import it
source=.bsf~new("java.io.File", "12-metadata added.pdf")
importdoc=BSF.loadClass("org.apache.pdfbox.Loader")
doc=importdoc~loadPDF(source)

-- count the number of pages 
pages=doc~getDocumentCatalog~getPages

-- start the loop for each page
do i= 1 to doc~getNumberOfPages
page=pages~get(i-1)

-- set the append mode
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
append=BSF.loadClass(contclass)~AppendMode~APPEND

-- create a content stream
cont=.bsf~new(contclass,doc,page,append,"true")

-- define font type

fontclass = "org.apache.pdfbox.pdmodel.font.Standard14Fonts"
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_BOLD
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)

-- use the content stream to insert content
cont~beginText
cont~setLeading(25f)
cont~setFont(font, 70)

-- set the transparency of the watermark
gsclass="org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState"
gs=.bsf~new(gsclass)
gs~setNonStrokingAlphaConstant(0.2)
cont~setGraphicsStateParameters(gs)

-- set the color of the watermark
col=BSF.loadClass("java.awt.Color")~red
cont~setNonStrokingColor(col)

-- set the rotation of the watermark
matrix=.bsf~new("org.apache.pdfbox.util.Matrix")
cont~setTextMatrix(matrix~getRotateInstance(20,150,100))

-- insert the watermark
cont~showText("This is a Watermark")
cont~endText
cont~close
end

-- save and close the document file
doc~save("13-watermark.pdf")
doc~close

-- get java support
::requires "BSF.CLS"